% Mikoaj Czajkowski , Wiktor Budziski 
% "Simulation error in maximum likelihood estimation of discrete choice
% models"
%
% Online materials
% 2019-03-08 

% Script produces tables presented in Appendix C

% INPUT: Code uses Output matrix from 'MTL_results05.mat' which can be generated with MTLcalc.m code

% OUTPUT: Code generates excel spreadsheet with Tables C1, C2 and C3

clear
clc
load('MTL_results05.mat')

%% Table C1
T3 = zeros(7,5);
T3(:,1) = [100, 200, 500, 1000, 2000, 5000, 10000]';

TableData = reshape(Output(:,1),[4,13,27,2]);
TableData = reshape(TableData(:,1:7,:,:),[4 7 27*2]); 
TableData(:,:,[28:36 46:54]) = [];
M = squeeze(min(TableData,[],1)); % 7 x 36
Res = NaN(7,36);

for i = 1:36
    for j = 1:7
        if ~isnan(M(j,i))
            Res(j,i) = find(TableData(:,j,i) == M(j,i));
        end
    end
end

T3(:,2:5) = [mean(Res == 1,2) mean(Res == 2,2) mean(Res == 3,2) mean(Res == 4,2)];
T3cell = cell(8,5);
T3cell(2:8,:) = num2cell(T3);
T3cell(1,:) = {'', 'Pseudo-Random', 'MLHS', 'Halton', 'Sobol'};

%% Table C2

T4 = zeros(7,5);
T4(:,1) = [100, 200, 500, 1000, 2000, 5000, 10000]';

TableData = reshape(Output(:,2:21),[4,13,27,2,20]);
TableData = TableData(:,1:7,:,:,:); 
TableData = reshape(TableData(:,1:7,:,:,:),[4 7 27*2,20]); 
TableData(:,:,[28:36 46:54],:) = [];
M = squeeze(min(TableData,[],1)); % 7 x 36 x 20
Res = NaN(7,27,20);

for i = 1:36
    for j = 1:7
        for k = 1:20
            if ~isnan(M(j,i,k))
                if size(find(TableData(:,j,i,k) == M(j,i,k)),1) > 1
                    M(j,i,k)
                    TableData(:,j,i,k)
                    Tmp = find(TableData(:,j,i,k) == M(j,i,k));
                    Res(j,i,k) = Tmp(1);
                else
                    Res(j,i,k) = find(TableData(:,j,i,k) == M(j,i,k));
                end
                
            end
        end
    end
end
Res = reshape(Res, [7, 36*20]);
Res = Res(:, ~isnan(Res(1,:)));
T4(:,2:5) = [mean(Res == 1,2) mean(Res == 2,2) mean(Res == 3,2) mean(Res == 4,2)];
T4cell = cell(8,5);
T4cell(2:8,:) = num2cell(T4);
T4cell(1,:) = {'', 'Pseudo-Random', 'MLHS', 'Halton', 'Sobol'};


%% Table C3

T5 = zeros(7,5);
T5(:,1) = [100, 200, 500, 1000, 2000, 5000, 10000]';

TableData = reshape(Output(:,22:41),[4,13,27,2,20]);
TableData = TableData(:,1:7,:,:,:); 
TableData = reshape(TableData(:,1:7,:,:,:),[4 7 27*2,20]); 
TableData(:,:,[28:36 46:54],:) = [];
M = squeeze(min(TableData,[],1)); % 7 x 36 x 20
Res = NaN(7,27,20);

for i = 1:36
    for j = 1:7
        for k = 1:20
            if ~isnan(M(j,i,k))
                if size(find(TableData(:,j,i,k) == M(j,i,k)),1) > 1
                    M(j,i,k)
                    TableData(:,j,i,k)
                    Tmp = find(TableData(:,j,i,k) == M(j,i,k));
                    Res(j,i,k) = Tmp(1);
                else
                    Res(j,i,k) = find(TableData(:,j,i,k) == M(j,i,k));
                end
                
            end
        end
    end
end
Res = reshape(Res, [7, 36*20]);
Res = Res(:, ~isnan(Res(1,:)));
T5(:,2:5) = [mean(Res == 1,2) mean(Res == 2,2) mean(Res == 3,2) mean(Res == 4,2)];
T5cell = cell(8,5);
T5cell(2:8,:) = num2cell(T5);
T5cell(1,:) = {'', 'Pseudo-Random', 'MLHS', 'Halton', 'Sobol'};


xlswrite('Results20190308.xls', T3cell, 'Appendix C', 'A1');
xlswrite('Results20190308.xls', T4cell, 'Appendix C', 'G1');
xlswrite('Results20190308.xls', T5cell, 'Appendix C', 'M1');